/******************************************************************************
* (C) Copyright 2002 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifdef WIN32 /* Whole file compiled under Windows only ! */

#include "AgtPCIPort.h"
#include "agtosport.h"
#include <assert.h>

// Remember last parameters set in protocol for speedup purposes

#if 0
  // This file is from a Best PCIX SW installation 2.9 resp. 3.0
  #include <xpciapi.h>
#else
  #define EXPORT __declspec(dllimport)
  #define BX_E_OK 0
  typedef unsigned long bx_errtype;
  typedef unsigned long bx_int32;
  typedef HANDLE bx_portnumtype;
#endif

extern "C"
{
  // These functions are imported from xcapikk.dll
  bx_errtype EXPORT BestXOpenPCI(int portnum,bx_portnumtype * pOsHandle);
  bx_errtype EXPORT BestXClosePCI(bx_portnumtype OsHandle);
  bx_errtype EXPORT BestXGetHPSlotIdFromOsHandle(bx_portnumtype OsHandle,bx_int32 * pdwHPSlotId);
  bx_errtype EXPORT BestXNTRegDevEnumGet(bx_int32 dwHPSlotId,bx_int32* pdwDevNum);
  bx_errtype EXPORT BestXPCIDWGet(bx_int32 Reg_N,bx_portnumtype OsHandle,bx_int32 * pResult);
  bx_errtype EXPORT BestXPCIDWSet(bx_int32 Reg_N,bx_portnumtype OsHandle,bx_int32 value);
  bx_errtype EXPORT BestXGetISPDWMem( bx_int32 Reg_N, bx_portnumtype OsHandle, bx_int32* pResult );
  bx_errtype EXPORT BestXSetISPDWMem( bx_int32 Reg_N, bx_portnumtype OsHandle, bx_int32 value );
  bx_errtype EXPORT BestXNTRegDevIDGet(bx_int32 dwVendorId,bx_int32 dwDeviceId,bx_int32 dwSubsysId,bx_int32 *pdwHPSlotId);
}

void CAgtOSPort::OSDeviceIdGet(UInt16 vendId,UInt16 devId,UInt16 index, UInt32* deviceId)
{
  bx_errtype err=BX_E_OK;
  
  bx_int32 devid32=AGT_INVALID_DEVID;
  err=BestXNTRegDevIDGet(vendId,devId,index,&devid32);
  if (err!=BX_E_OK)
  {
    // Card not found.
    // No exception here, because this is considered normal termination during device searching
    *deviceId=AGT_INVALID_DEVID;
  }
  else
  {
    // Card found
    *deviceId=/*(UInt16)*/devid32;
  }
}

void CAgtOSPort::OSOpenPort(UInt32 deviceId, HANDLE &osHandle,AgtPortHandleT *portHandle)
{
  bx_errtype err=BX_E_OK;

  HANDLE tmpOsHandle=AGT_INVALID_OSHANDLE;

  err=BestXOpenPCI(deviceId,(bx_portnumtype*)&tmpOsHandle);
  if (err!=BX_E_OK)
  {
    AGT_THROW("Could not open PCIE driver");
  }

  err=BestXNTRegDevEnumGet(deviceId,portHandle);
  if (err!=BX_E_OK)
  {
    AGT_THROW("Could not read device index from registry");
  }

  // Set return value
  osHandle=tmpOsHandle;
}

void CAgtOSPort::OSClosePort(HANDLE osHandle)
{
  bx_errtype err=BX_E_OK;

  assert(osHandle); // precondition

  err=BestXClosePCI(osHandle);

  if (err!=BX_E_OK)
  {
    AGT_THROW("Could not close PCIE driver");
  }
}

void CAgtOSPort::OSConfRegDirectRead(HANDLE myOSHandle,UInt32 address,UInt32 &val)
{
  // Executes a direct config access without using
  // the PCI API protocol.

  bx_errtype err=BX_E_OK;
  UInt32 value=0;
  err=BestXPCIDWGet(address,myOSHandle,&value);
  if (err!=BX_E_OK) AGT_THROW("Could not get value in PCIEAPI OSConfRegDirectRead");
  val=value;
}

void CAgtOSPort::OSConfRegDirectWrite(HANDLE myOSHandle,UInt32 address,UInt32 val)
{
  // Executes a direct config access without using
  // the PCI API protocol.

  bx_errtype err=BX_E_OK;
  err=BestXPCIDWSet(address,myOSHandle,val);

  if (err!=BX_E_OK) AGT_THROW("Could not set value in PCIEAPI OSConfRegDirectWrite");
}

// Read/Write value to ISP registers using MemRd/MemWr
void CAgtOSPort::OSISPRegRead( HANDLE myOSHandle, UInt32 address, UInt32 &val )
{
  bx_errtype err = BX_E_OK;
  UInt32 value = 0;

  err = BestXGetISPDWMem( address, myOSHandle, &value );

  if( err != BX_E_OK )
    AGT_THROW( "Could not get value in OSISPRegRead" );

  val = value;
}

void CAgtOSPort::OSISPRegWrite( HANDLE myOSHandle, UInt32 address, UInt32 val )
{
  bx_errtype err = BX_E_OK;

  err = BestXSetISPDWMem( address, myOSHandle, val );

  if( err != BX_E_OK )
    AGT_THROW( "Could not set value in OSISPRegWrite" );
}

#endif